/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LiquidBlockRenderer {
    private static final float MAX_FLUID_HEIGHT = 0.8888889f;
    private final TextureAtlasSprite[] lavaIcons = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] waterIcons = new TextureAtlasSprite[2];
    private TextureAtlasSprite waterOverlay;

    protected void setupSprites() {
        this.lavaIcons[0] = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(Blocks.LAVA.defaultBlockState()).getParticleIcon();
        this.lavaIcons[1] = ModelBakery.LAVA_FLOW.sprite();
        this.waterIcons[0] = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(Blocks.WATER.defaultBlockState()).getParticleIcon();
        this.waterIcons[1] = ModelBakery.WATER_FLOW.sprite();
        this.waterOverlay = ModelBakery.WATER_OVERLAY.sprite();
    }

    private static boolean isNeighborSameFluid(FluidState p_203186_, FluidState p_203187_) {
        return p_203187_.getType().isSame(p_203186_.getType());
    }

    private static boolean isFaceOccludedByState(BlockGetter p_110979_, Direction p_110980_, float p_110981_, BlockPos p_110982_, BlockState p_110983_) {
        if (p_110983_.canOcclude()) {
            VoxelShape $$5 = Shapes.box(0.0, 0.0, 0.0, 1.0, p_110981_, 1.0);
            VoxelShape $$6 = p_110983_.getOcclusionShape(p_110979_, p_110982_);
            return Shapes.blockOccudes($$5, $$6, p_110980_);
        }
        return false;
    }

    private static boolean isFaceOccludedByNeighbor(BlockGetter p_203180_, BlockPos p_203181_, Direction p_203182_, float p_203183_, BlockState p_203184_) {
        return LiquidBlockRenderer.isFaceOccludedByState(p_203180_, p_203182_, p_203183_, p_203181_.relative(p_203182_), p_203184_);
    }

    private static boolean isFaceOccludedBySelf(BlockGetter p_110960_, BlockPos p_110961_, BlockState p_110962_, Direction p_110963_) {
        return LiquidBlockRenderer.isFaceOccludedByState(p_110960_, p_110963_.getOpposite(), 1.0f, p_110961_, p_110962_);
    }

    public static boolean shouldRenderFace(BlockAndTintGetter p_203167_, BlockPos p_203168_, FluidState p_203169_, BlockState p_203170_, Direction p_203171_, FluidState p_203172_) {
        return !LiquidBlockRenderer.isFaceOccludedBySelf(p_203167_, p_203168_, p_203170_, p_203171_) && !LiquidBlockRenderer.isNeighborSameFluid(p_203169_, p_203172_);
    }

    /*
     * WARNING - void declaration
     */
    public void tesselate(BlockAndTintGetter p_234370_, BlockPos p_234371_, VertexConsumer p_234372_, BlockState p_234373_, FluidState p_234374_) {
        float $$51;
        float $$46;
        float $$45;
        float $$44;
        float $$43;
        boolean $$5 = p_234374_.is(FluidTags.LAVA);
        TextureAtlasSprite[] $$6 = $$5 ? this.lavaIcons : this.waterIcons;
        int $$7 = $$5 ? 0xFFFFFF : BiomeColors.getAverageWaterColor(p_234370_, p_234371_);
        float $$8 = (float)($$7 >> 16 & 0xFF) / 255.0f;
        float $$9 = (float)($$7 >> 8 & 0xFF) / 255.0f;
        float $$10 = (float)($$7 & 0xFF) / 255.0f;
        BlockState $$11 = p_234370_.getBlockState(p_234371_.relative(Direction.DOWN));
        FluidState $$12 = $$11.getFluidState();
        BlockState $$13 = p_234370_.getBlockState(p_234371_.relative(Direction.UP));
        FluidState $$14 = $$13.getFluidState();
        BlockState $$15 = p_234370_.getBlockState(p_234371_.relative(Direction.NORTH));
        FluidState $$16 = $$15.getFluidState();
        BlockState $$17 = p_234370_.getBlockState(p_234371_.relative(Direction.SOUTH));
        FluidState $$18 = $$17.getFluidState();
        BlockState $$19 = p_234370_.getBlockState(p_234371_.relative(Direction.WEST));
        FluidState $$20 = $$19.getFluidState();
        BlockState $$21 = p_234370_.getBlockState(p_234371_.relative(Direction.EAST));
        FluidState $$22 = $$21.getFluidState();
        boolean $$23 = !LiquidBlockRenderer.isNeighborSameFluid(p_234374_, $$14);
        boolean $$24 = LiquidBlockRenderer.shouldRenderFace(p_234370_, p_234371_, p_234374_, p_234373_, Direction.DOWN, $$12) && !LiquidBlockRenderer.isFaceOccludedByNeighbor(p_234370_, p_234371_, Direction.DOWN, 0.8888889f, $$11);
        boolean $$25 = LiquidBlockRenderer.shouldRenderFace(p_234370_, p_234371_, p_234374_, p_234373_, Direction.NORTH, $$16);
        boolean $$26 = LiquidBlockRenderer.shouldRenderFace(p_234370_, p_234371_, p_234374_, p_234373_, Direction.SOUTH, $$18);
        boolean $$27 = LiquidBlockRenderer.shouldRenderFace(p_234370_, p_234371_, p_234374_, p_234373_, Direction.WEST, $$20);
        boolean $$28 = LiquidBlockRenderer.shouldRenderFace(p_234370_, p_234371_, p_234374_, p_234373_, Direction.EAST, $$22);
        if (!($$23 || $$24 || $$28 || $$27 || $$25 || $$26)) {
            return;
        }
        float $$29 = p_234370_.getShade(Direction.DOWN, true);
        float $$30 = p_234370_.getShade(Direction.UP, true);
        float $$31 = p_234370_.getShade(Direction.NORTH, true);
        float $$32 = p_234370_.getShade(Direction.WEST, true);
        Fluid $$33 = p_234374_.getType();
        float $$34 = this.getHeight(p_234370_, $$33, p_234371_, p_234373_, p_234374_);
        if ($$34 >= 1.0f) {
            float $$35 = 1.0f;
            float $$36 = 1.0f;
            float $$37 = 1.0f;
            float $$38 = 1.0f;
        } else {
            float $$39 = this.getHeight(p_234370_, $$33, p_234371_.north(), $$15, $$16);
            float $$40 = this.getHeight(p_234370_, $$33, p_234371_.south(), $$17, $$18);
            float $$41 = this.getHeight(p_234370_, $$33, p_234371_.east(), $$21, $$22);
            float $$42 = this.getHeight(p_234370_, $$33, p_234371_.west(), $$19, $$20);
            $$43 = this.calculateAverageHeight(p_234370_, $$33, $$34, $$39, $$41, p_234371_.relative(Direction.NORTH).relative(Direction.EAST));
            $$44 = this.calculateAverageHeight(p_234370_, $$33, $$34, $$39, $$42, p_234371_.relative(Direction.NORTH).relative(Direction.WEST));
            $$45 = this.calculateAverageHeight(p_234370_, $$33, $$34, $$40, $$41, p_234371_.relative(Direction.SOUTH).relative(Direction.EAST));
            $$46 = this.calculateAverageHeight(p_234370_, $$33, $$34, $$40, $$42, p_234371_.relative(Direction.SOUTH).relative(Direction.WEST));
        }
        float $$47 = p_234371_.getX() & 0xF;
        float $$48 = p_234371_.getY() & 0xF;
        float $$49 = p_234371_.getZ() & 0xF;
        float $$50 = 0.001f;
        float f = $$51 = $$24 ? 0.001f : 0.0f;
        if ($$23 && !LiquidBlockRenderer.isFaceOccludedByNeighbor(p_234370_, p_234371_, Direction.UP, Math.min(Math.min($$44, $$46), Math.min($$45, $$43)), $$13)) {
            float $$74;
            float $$73;
            float $$72;
            float $$71;
            float $$70;
            float $$69;
            float $$68;
            float $$67;
            $$44 -= 0.001f;
            $$46 -= 0.001f;
            $$45 -= 0.001f;
            $$43 -= 0.001f;
            Vec3 $$52 = p_234374_.getFlow(p_234370_, p_234371_);
            if ($$52.x == 0.0 && $$52.z == 0.0) {
                TextureAtlasSprite $$53 = $$6[0];
                float $$54 = $$53.getU(0.0f);
                float $$55 = $$53.getV(0.0f);
                float $$56 = $$54;
                float $$57 = $$53.getV(1.0f);
                float $$58 = $$53.getU(1.0f);
                float $$59 = $$57;
                float $$60 = $$58;
                float $$61 = $$55;
            } else {
                TextureAtlasSprite $$62 = $$6[1];
                float $$63 = (float)Mth.atan2($$52.z, $$52.x) - 1.5707964f;
                float $$64 = Mth.sin($$63) * 0.25f;
                float $$65 = Mth.cos($$63) * 0.25f;
                float $$66 = 0.5f;
                $$67 = $$62.getU(0.5f + (-$$65 - $$64));
                $$68 = $$62.getV(0.5f + (-$$65 + $$64));
                $$69 = $$62.getU(0.5f + (-$$65 + $$64));
                $$70 = $$62.getV(0.5f + ($$65 + $$64));
                $$71 = $$62.getU(0.5f + ($$65 + $$64));
                $$72 = $$62.getV(0.5f + ($$65 - $$64));
                $$73 = $$62.getU(0.5f + ($$65 - $$64));
                $$74 = $$62.getV(0.5f + (-$$65 - $$64));
            }
            float $$75 = ($$67 + $$69 + $$71 + $$73) / 4.0f;
            float $$76 = ($$68 + $$70 + $$72 + $$74) / 4.0f;
            float $$77 = $$6[0].uvShrinkRatio();
            $$67 = Mth.lerp($$77, $$67, $$75);
            $$69 = Mth.lerp($$77, $$69, $$75);
            $$71 = Mth.lerp($$77, $$71, $$75);
            $$73 = Mth.lerp($$77, $$73, $$75);
            $$68 = Mth.lerp($$77, $$68, $$76);
            $$70 = Mth.lerp($$77, $$70, $$76);
            $$72 = Mth.lerp($$77, $$72, $$76);
            $$74 = Mth.lerp($$77, $$74, $$76);
            int $$78 = this.getLightColor(p_234370_, p_234371_);
            float $$79 = $$30 * $$8;
            float $$80 = $$30 * $$9;
            float $$81 = $$30 * $$10;
            this.vertex(p_234372_, $$47 + 0.0f, $$48 + $$44, $$49 + 0.0f, $$79, $$80, $$81, $$67, $$68, $$78);
            this.vertex(p_234372_, $$47 + 0.0f, $$48 + $$46, $$49 + 1.0f, $$79, $$80, $$81, $$69, $$70, $$78);
            this.vertex(p_234372_, $$47 + 1.0f, $$48 + $$45, $$49 + 1.0f, $$79, $$80, $$81, $$71, $$72, $$78);
            this.vertex(p_234372_, $$47 + 1.0f, $$48 + $$43, $$49 + 0.0f, $$79, $$80, $$81, $$73, $$74, $$78);
            if (p_234374_.shouldRenderBackwardUpFace(p_234370_, p_234371_.above())) {
                this.vertex(p_234372_, $$47 + 0.0f, $$48 + $$44, $$49 + 0.0f, $$79, $$80, $$81, $$67, $$68, $$78);
                this.vertex(p_234372_, $$47 + 1.0f, $$48 + $$43, $$49 + 0.0f, $$79, $$80, $$81, $$73, $$74, $$78);
                this.vertex(p_234372_, $$47 + 1.0f, $$48 + $$45, $$49 + 1.0f, $$79, $$80, $$81, $$71, $$72, $$78);
                this.vertex(p_234372_, $$47 + 0.0f, $$48 + $$46, $$49 + 1.0f, $$79, $$80, $$81, $$69, $$70, $$78);
            }
        }
        if ($$24) {
            float $$82 = $$6[0].getU0();
            float $$83 = $$6[0].getU1();
            float $$84 = $$6[0].getV0();
            float $$85 = $$6[0].getV1();
            int $$86 = this.getLightColor(p_234370_, p_234371_.below());
            float $$87 = $$29 * $$8;
            float $$88 = $$29 * $$9;
            float $$89 = $$29 * $$10;
            this.vertex(p_234372_, $$47, $$48 + $$51, $$49 + 1.0f, $$87, $$88, $$89, $$82, $$85, $$86);
            this.vertex(p_234372_, $$47, $$48 + $$51, $$49, $$87, $$88, $$89, $$82, $$84, $$86);
            this.vertex(p_234372_, $$47 + 1.0f, $$48 + $$51, $$49, $$87, $$88, $$89, $$83, $$84, $$86);
            this.vertex(p_234372_, $$47 + 1.0f, $$48 + $$51, $$49 + 1.0f, $$87, $$88, $$89, $$83, $$85, $$86);
        }
        int $$90 = this.getLightColor(p_234370_, p_234371_);
        for (Direction $$91 : Direction.Plane.HORIZONTAL) {
            Block $$122;
            boolean $$119;
            float $$118;
            float $$117;
            float $$116;
            float $$115;
            void $$114;
            float $$113;
            switch ($$91) {
                case NORTH: {
                    void $$92 = $$44;
                    float $$93 = $$43;
                    float $$94 = $$47;
                    float $$95 = $$47 + 1.0f;
                    float $$96 = $$49 + 0.001f;
                    float $$97 = $$49 + 0.001f;
                    boolean $$98 = $$25;
                    break;
                }
                case SOUTH: {
                    void $$99 = $$45;
                    void $$100 = $$46;
                    float $$101 = $$47 + 1.0f;
                    float $$102 = $$47;
                    float $$103 = $$49 + 1.0f - 0.001f;
                    float $$104 = $$49 + 1.0f - 0.001f;
                    boolean $$105 = $$26;
                    break;
                }
                case WEST: {
                    void $$106 = $$46;
                    void $$107 = $$44;
                    float $$108 = $$47 + 0.001f;
                    float $$109 = $$47 + 0.001f;
                    float $$110 = $$49 + 1.0f;
                    float $$111 = $$49;
                    boolean $$112 = $$27;
                    break;
                }
                default: {
                    $$113 = $$43;
                    $$114 = $$45;
                    $$115 = $$47 + 1.0f - 0.001f;
                    $$116 = $$47 + 1.0f - 0.001f;
                    $$117 = $$49;
                    $$118 = $$49 + 1.0f;
                    $$119 = $$28;
                }
            }
            if (!$$119 || LiquidBlockRenderer.isFaceOccludedByNeighbor(p_234370_, p_234371_, $$91, Math.max($$113, (float)$$114), p_234370_.getBlockState(p_234371_.relative($$91)))) continue;
            BlockPos $$120 = p_234371_.relative($$91);
            TextureAtlasSprite $$121 = $$6[1];
            if (!$$5 && (($$122 = p_234370_.getBlockState($$120).getBlock()) instanceof HalfTransparentBlock || $$122 instanceof LeavesBlock)) {
                $$121 = this.waterOverlay;
            }
            float $$123 = $$121.getU(0.0f);
            float $$124 = $$121.getU(0.5f);
            float $$125 = $$121.getV((1.0f - $$113) * 0.5f);
            float $$126 = $$121.getV((1.0f - $$114) * 0.5f);
            float $$127 = $$121.getV(0.5f);
            float $$128 = $$91.getAxis() == Direction.Axis.Z ? $$31 : $$32;
            float $$129 = $$30 * $$128 * $$8;
            float $$130 = $$30 * $$128 * $$9;
            float $$131 = $$30 * $$128 * $$10;
            this.vertex(p_234372_, $$115, $$48 + $$113, $$117, $$129, $$130, $$131, $$123, $$125, $$90);
            this.vertex(p_234372_, $$116, $$48 + $$114, $$118, $$129, $$130, $$131, $$124, $$126, $$90);
            this.vertex(p_234372_, $$116, $$48 + $$51, $$118, $$129, $$130, $$131, $$124, $$127, $$90);
            this.vertex(p_234372_, $$115, $$48 + $$51, $$117, $$129, $$130, $$131, $$123, $$127, $$90);
            if ($$121 == this.waterOverlay) continue;
            this.vertex(p_234372_, $$115, $$48 + $$51, $$117, $$129, $$130, $$131, $$123, $$127, $$90);
            this.vertex(p_234372_, $$116, $$48 + $$51, $$118, $$129, $$130, $$131, $$124, $$127, $$90);
            this.vertex(p_234372_, $$116, $$48 + $$114, $$118, $$129, $$130, $$131, $$124, $$126, $$90);
            this.vertex(p_234372_, $$115, $$48 + $$113, $$117, $$129, $$130, $$131, $$123, $$125, $$90);
        }
    }

    private float calculateAverageHeight(BlockAndTintGetter p_203150_, Fluid p_203151_, float p_203152_, float p_203153_, float p_203154_, BlockPos p_203155_) {
        if (p_203154_ >= 1.0f || p_203153_ >= 1.0f) {
            return 1.0f;
        }
        float[] $$6 = new float[2];
        if (p_203154_ > 0.0f || p_203153_ > 0.0f) {
            float $$7 = this.getHeight(p_203150_, p_203151_, p_203155_);
            if ($$7 >= 1.0f) {
                return 1.0f;
            }
            this.addWeightedHeight($$6, $$7);
        }
        this.addWeightedHeight($$6, p_203152_);
        this.addWeightedHeight($$6, p_203154_);
        this.addWeightedHeight($$6, p_203153_);
        return $$6[0] / $$6[1];
    }

    private void addWeightedHeight(float[] p_203189_, float p_203190_) {
        if (p_203190_ >= 0.8f) {
            p_203189_[0] = p_203189_[0] + p_203190_ * 10.0f;
            p_203189_[1] = p_203189_[1] + 10.0f;
        } else if (p_203190_ >= 0.0f) {
            p_203189_[0] = p_203189_[0] + p_203190_;
            p_203189_[1] = p_203189_[1] + 1.0f;
        }
    }

    private float getHeight(BlockAndTintGetter p_203157_, Fluid p_203158_, BlockPos p_203159_) {
        BlockState $$3 = p_203157_.getBlockState(p_203159_);
        return this.getHeight(p_203157_, p_203158_, p_203159_, $$3, $$3.getFluidState());
    }

    private float getHeight(BlockAndTintGetter p_203161_, Fluid p_203162_, BlockPos p_203163_, BlockState p_203164_, FluidState p_203165_) {
        if (p_203162_.isSame(p_203165_.getType())) {
            BlockState $$5 = p_203161_.getBlockState(p_203163_.above());
            if (p_203162_.isSame($$5.getFluidState().getType())) {
                return 1.0f;
            }
            return p_203165_.getOwnHeight();
        }
        if (!p_203164_.isSolid()) {
            return 0.0f;
        }
        return -1.0f;
    }

    private void vertex(VertexConsumer p_110985_, float p_110989_, float p_110990_, float p_110991_, float p_110992_, float p_110993_, float p_350595_, float p_350459_, float p_350437_, int p_110994_) {
        p_110985_.addVertex(p_110989_, p_110990_, p_110991_).setColor(p_110992_, p_110993_, p_350595_, 1.0f).setUv(p_350459_, p_350437_).setLight(p_110994_).setNormal(0.0f, 1.0f, 0.0f);
    }

    private int getLightColor(BlockAndTintGetter p_110946_, BlockPos p_110947_) {
        int $$2 = LevelRenderer.getLightColor(p_110946_, p_110947_);
        int $$3 = LevelRenderer.getLightColor(p_110946_, p_110947_.above());
        int $$4 = $$2 & 0xFF;
        int $$5 = $$3 & 0xFF;
        int $$6 = $$2 >> 16 & 0xFF;
        int $$7 = $$3 >> 16 & 0xFF;
        return ($$4 > $$5 ? $$4 : $$5) | ($$6 > $$7 ? $$6 : $$7) << 16;
    }
}

